<?php
/* --------------------------------------------------------------
  EanDto.php 2020-02-24
  Gambio GmbH
  http://www.gambio.de
  Copyright (c) 2020 Gambio GmbH
  Released under the GNU General Public License (Version 2)
  [http://www.gnu.org/licenses/gpl-2.0.html]
  --------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Shop\Attributes\SellingUnitEan\Repository\Dto;

/**
 * Class EanDto
 * @package Gambio\Shop\Attributes\SellingUnitEan\Repository\Dto
 */
class EanDto
{
    /**
     * @var string|null
     */
    protected $valueEan;
    
    
    /**
     * EanDto constructor.
     *
     * @param string|null $valueEan
     */
    public function __construct(?string $valueEan)
    {
        $this->valueEan = $valueEan;
    }
    
    
    /**
     * @return string|null
     */
    public function value() : ?string
    {
        return $this->valueEan;
    }
    
}